#include <bits/stdc++.h>

using namespace std;
typedef long long ll;

const int N = 3e5 + 7;
vector<vector<pair<int,char>>> g(N);
map<char,int> val = {{'S', 0}, {'I', 1}, {'O', 2}};
int n;

struct edge {
    int u, v;
    char w;
} e[N];

void make_graph() {
    for (int i = 1; i < n; i++) {
        g[e[i].u].push_back(make_pair(e[i].v, e[i].w));
        g[e[i].v].push_back({e[i].u, e[i].w});
    }
}

void sol1() {
    vector<vector<int>> c(N, {0, 0, 0});
    for (int i = 1; i < n; i++) {
        c[e[i].u][val[e[i].w]]++;
        c[e[i].v][val[e[i].w]]++;
    }
    int p = 1;
    for (int i = 2; i < n; i++) {
        p = (e[i].w == 'S' ? i : p);
    }
    int x = e[p].u, y = e[p].v;
    ll res = 0;
    for (pair<int,char> i : g[x]) {
        if (i.second == 'S') {
            continue;
        }
        char z = (i.second == 'I' ? 'O' : 'I');
        res += c[i.first][val[z]];
    }
    for (pair<int,char> i : g[y]) {
        if (i.second == 'S') {
            continue;
        }
        char z = (i.second == 'I' ? 'O' : 'I');
        res += c[i.first][val[z]];
    }
    res += (ll)(c[x][val['I']]) * c[y][val['O']];
    res += (ll)(c[x][val['O']]) * c[y][val['I']];
    cout << res << endl;
    exit(0);
}

void dfs(int x, int par, vector<vector<int>> &c) {
    for (pair<int,char> i : g[x]) {
        if (i.first != par) {
            c[i.first] = c[par];
            c[i.first][val[i.second]]++;
            dfs(i.first, x, c);
        }
    }
}

void sol2() {
    ll res = 0;
    for (int i = 1; i <= n; i++) {
        vector<vector<int>> c(n + 1, {0, 0, 0});
        dfs(i, 0, c);
        for (int j = i + 1; j <= n; j++) {
            if (c[j][0] == c[j][1] && c[j][1] == c[j][2]) {
                res++;
            }
        }
    }
    cout << res << endl;
    exit(0);
}

void sol3() {
    vector<vector<int>> a = {{0, 0, 0}};
    vector<vector<int>> c(n + 1, {0, 0, 0});
    for (int i = 2; i <= n; i++) {
        c[i] = c[i - 1];
        int ch = g[i][0].second;
        if (g[i][0].first != i - 1) {
            ch = g[i][1].second;
        }
        c[i][val[ch]]++;
        int m = min(c[i][0], min(c[i][1], c[i][2]));
        c[i][0] -= m; c[i][1] -= m; c[i][2] -= m;
        a.push_back(c[i]);
    }
    sort(a.begin(), a.end());
    ll res = 0, cnt = 1;
    for (int i = 1; i < n; i++) {
        if (a[i] == a[i - 1]) {
            cnt++; continue;
        }
        res += cnt * (cnt - 1) / 2;
        cnt = 1;
    }
    res += cnt * (cnt - 1) / 2;
    cout << res << endl;
    exit(0);
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cin >> n;
    int t[] = {0, 0, 0};
    for (int i = 1; i < n; i++) {
        cin >> e[i].u >> e[i].v >> e[i].w;
        t[val[e[i].w]]++;
    }
    if (min(t[0], min(t[1], t[2])) == 0) {
        return cout << 0 << endl, 0;
    }
    if (min(t[0], min(t[1], t[2])) == 1) {
        int ch = (t[0] == 1 ? 'S' : t[1] == 1 ? 'I' : 'O');
        for (int i = 1; i < n; i++) {
            if (e[i].w == 'S') {
                e[i].w = ch;
            }
            else if (e[i].w == ch) {
                e[i].w = 'S';
            }
        }
        make_graph();
        sol1();
    }
    if (n <= 1000) {
        make_graph(); sol2();
    }
    bool t3 = true;
    for (int i = 1; i < n; i++) {
        t3 &= (abs(e[i].u - e[i].v) == 1);
    }
    if (t3) {
        make_graph(); sol3();
    }
    return 0;
}